<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;  
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file


// function to modify page trail of subs
function modify_page_trail($iOldRootParent,$iNewRootParent)
{
	// Get objects and vars from outside this function
	global $admin, $database, $TEXT, $MESSAGE;
	
	// Get page list from database
	$aAllPages = [];
	$database->execute_query(
		"SELECT * FROM `".TABLE_PREFIX."pages` WHERE `root_parent` = ".$iOldRootParent." AND page_id != ".$iOldRootParent  ,
		true,
		$aAllPages,
		true
	);

	// Insert correct values into page list
	foreach ($aAllPages as &$page)
	{
		 $sCurrentPageTrail = $page['page_trail'];
		 $aCurrentPageTrail = explode(',',$sCurrentPageTrail);
		 
		if($page['root_parent'] == $page['parent'])
		{
			 // add element as index[0]
			 array_unshift($aCurrentPageTrail,$iNewRootParent);
			 $sNewPageTrail = implode(',',$aCurrentPageTrail);				
		}
		else
		{
			 // replace first element 
			 $aCurrentPageTrail[0] = $iNewRootParent;
			 $aCurrentPageTrail = array_unique($aCurrentPageTrail);
			 $sNewPageTrail = implode(',',$aCurrentPageTrail);		
		}

		// Save new page trail
		$database->simple_query("UPDATE ".TABLE_PREFIX."pages SET root_parent = ".$iNewRootParent.", page_trail = '".$sNewPageTrail."' WHERE `page_id` = ".$page['page_id']);
    }
}

