<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl-3.0.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file


// get twig instance
$oTWIG = lib_twig_box::getInstance();
// get admin instance
$admin = LEPTON_admin::getInstance('Start', 'start', false, false);
// get database instance
$database = LEPTON_database::getInstance();

// Get the website title
$website_title = $database->get_one("SELECT `value` FROM `".TABLE_PREFIX."settings` WHERE `name` = 'title'");

$MESSAGE = LEPTON_core::getGlobal("MESSAGE");
$MENU = LEPTON_core::getGlobal("MENU");

$sInfoMessage = '';

// create hash 
$confirm_hash = time();

// create confirmation link
$enter_pw_link = LEPTON_URL.'/account/new_password.php?hash='.$confirm_hash;

// Check if the user has already submitted the form, otherwise show it
if ((isset($_POST['email'])) && ($_POST['email'] != ""))
{
    $email = strip_tags($_POST['email']);

    if (false === LEPTON_handle::checkEmailChars($email))
    {
        $sInfoMessage = $MESSAGE['USERS_INVALID_EMAIL'];
    }
    else 
	{
        //	check if mail is in database
        $subscriber = [];
        $database->execute_query(
            "SELECT * FROM `".TABLE_PREFIX."users` WHERE email = '".$email."' ",
            true,
            $subscriber,
            false
        );

        if(empty($subscriber) )
        {
            // info that email doesn't exist	
            $sInfoMessage = $MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND'];
        
        } 
		else 
		{
            // Check if the password has been reset in the last 2 hours
            $last_reset = intval($subscriber['login_ip']);
            $time_diff = time()-$last_reset; // Time since last reset in seconds
            $time_diff = $time_diff/60/60; // Time since last reset in hours
            if ($time_diff < 2)
            {
                // Tell the user that their password cannot be reset more than once per hour
                $sInfoMessage = $MESSAGE['FORGOT_PASS_ALREADY_RESET'];
            } 
			else 
			{		
                //send confirmation link to email
                //Create a new Mailer instance
                $mail = LEPTON_mailer::getInstance();
                $mail->CharSet = DEFAULT_CHARSET;	
                //Set who the message is to be sent from
                $mail->setFrom(SERVER_EMAIL);
                //Set who the message is to be sent to
                $mail->addAddress($email);
                //Set the subject line
                $mail->Subject = $MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO'];
                //Switch to TEXT messages
                $mail->IsHTML(true);
                $mail->Body = sprintf($MESSAGE['FORGOT_PASS_PASSWORD_CONFIRM'],$enter_pw_link,$enter_pw_link);	

                //send the message, check for errors
                if (!$mail->send())
                {
                    $sInfoMessage = "Mailer Error: " . $mail->ErrorInfo;
                } 
				else 
				{
                    //save into database
                    $fields = array(
                        'login_ip'=>	$confirm_hash
                    );
                    $database->build_and_execute( 'UPDATE', TABLE_PREFIX."users", $fields,"email = '".$email."'");

                    $sInfoMessage = $MESSAGE['FORGOT_PASS_PASSWORD_RESET'];
                }
            }
        }
    }
}

if (!isset($sInfoMessage))
{
    $sInfoMessage = $MESSAGE['FORGOT_PASS_NO_DATA'];
	$message_color = '000000';
} 
else 
{
	$message_color = 'FF0000';
}

$page_values = [
	'ACTION_URL' => ADMIN_URL.'/login/forgot/index.php',
	'SECTION_FORGOT' => $MENU['FORGOT'],
	'MESSAGE_COLOR' => $message_color,
	'MESSAGE' => $sInfoMessage
];

echo $oTWIG->render(
	"@theme/login_forgot.lte",
	$page_values
);
