<?php

declare(strict_types=1);

/**
 * @module          Cookie
 * @author          cms-lab
 * @copyright       2010-2025 cms-lab
 * @link            https://cms-lab.com
 * @license         custom license: https://cms-lab.com/_documentation/cookie/license.php
 * @license_terms   see: https://cms-lab.com/_documentation/cookie/license.php
 *
 */

class cookie extends LEPTON_abstract
{
	public array $cookie_settings = [];
	public string $addon_color = 'blue';
	public string $sActionUrl = ADMIN_URL . '/admintools/tool.php?tool=cookie';
	public string $sBackUrl = ADMIN_URL . '/admintools/index.php';
	public string $cookie_js = LEPTON_URL.'/modules/cookie/js/cookieconsent.min.js';
	public string $cookie_css = LEPTON_URL.'/modules/cookie/css/cookieconsent.min.css';	

	public object|null $oTwig = null;		
	public LEPTON_database $database;
	public static $instance;

	public function initialize() 
	{
		$this->database = LEPTON_database::getInstance();
		$this->oTwig = lib_twig_box::getInstance();
		$this->oTwig->registerModule('cookie');			
		$this->init_tool();
	}

	public function init_tool()
	{
		// Get current settings form the db as array
		$this->database->execute_query(
			"SELECT * FROM ".TABLE_PREFIX."mod_cookie",
			true,
			$this->cookie_settings,
			false
		);
	}


	public function list_settings()
	{
		// data for twig template engine	
		$data = [
			'oCO'		=> $this,
			'leptoken'	=> get_leptoken(),
			'read_me'	=> "https://cms-lab.com/_documentation/cookie/readme.php"
        ];
	
		//	get the template-engine
		echo $this->oTwig->render( 
			"@cookie/tool.lte",	//	template-filename
			$data				//	template-data
		);		
	}


	// function called from backend
	public function save_settings(int $id = 0 )
	{
		if($id < 1)
		{
			exit();
		}
		
		$database = LEPTON_database::getInstance();

		//	save elements
		$oREQUEST = LEPTON_request::getInstance();

		$all_fields = array (
			'position'	=> array ('type' => 'string_clean', 'default' => ""),
			'layout' 	=> array ('type' => 'string_clean', 'default' => ""),
			'pop_bg'	=> array ('type' => 'string_clean', 'default' => ""),
			'pop_text'	=> array ('type' => 'string_clean', 'default' => ""),
			'but_bg'	=> array ('type' => 'string_clean', 'default' => ""),
			'but_text'	=> array ('type' => 'string_clean', 'default' => ""),
			'but_border'=> array ('type' => 'string_clean', 'default' => ""),
			'type'		=> array ('type' => 'string_clean', 'default' => ""),
			'href'		=> array ('type' => 'string_clean', 'default' => ""),
			'message'	=> array ('type' => 'string_clean', 'default' => ""),
			'dismiss'	=> array ('type' => 'string_clean', 'default' => ""),
			'allow'		=> array ('type' => 'string_clean', 'default' => ""),
			'deny'		=> array ('type' => 'string_clean', 'default' => ""),
			'link'		=> array ('type' => 'string_clean', 'default' => ""),
			'overwrite' => array ('type' => 'integer', 'default' => 0)
		);
		$all_values = $oREQUEST->testPostValues($all_fields);

		$table = TABLE_PREFIX."mod_cookie";
		$database->build_and_execute(
			'UPDATE',
			$table,
			$all_values,
			"cookie_id = ".$id
		);

		
		LEPTON_admin::displayMessage(
			"success",
			[$this->language['SAVE_OK']],
			$this->sActionUrl,
			2000,
			"message.lte",
			true
		);

	}

	// called from droplet
	public function build_js()
	{
		// data for twig template engine
		$data = array(
			'oCOOKIE'		=> $this,
			'js_class'		=> '{{classes}}',
			'readme_link'	=> "https://cms-lab.com/_documentation/cookie/readme.php",
			'example_link'	=> "https://cookieconsent.insites.com/demos/"
		);

		//	get the template-engine
		return $this->oTwig->render(
			"@cookie/output.lte",	//	template-filename
			$data						//	template-data
		);
	}
	
	
	public function show_info() 
	{
		// data for twig template engine	
		$data = [
			'oCO'			=> $this,
			'image_url'		=> "https://cms-lab.com/_documentation/media/cookie/cookie.jpg",
			'readme_link'	=> "<a class='ui basic blue button' href='https://cms-lab.com/_documentation/cookie/readme.php' target='_blank'><i class='book icon'></i>Readme</a>",
			'live_support'	=> "<a  class='ui basic red button' href='#'><i class='bookmark icon'></i>NO Live-Support</a>",			
			'forum_support'	=> "<a class='ui basic blue button' href='https://forum.lepton-cms.org/viewforum.php?f=14' target='_blank'><i class='bookmark icon'></i>Forum-Support</a>"
			];

		//	get the template-engine		
		echo $this->oTwig->render( 
			"@cookie/info.lte",	//	template-filename
			$data				//	template-data
		);		
	}
}
