<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl-3.0.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */
 
// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;  
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file

// Get page id
if(!isset($_POST['page_id']) OR !is_numeric($_POST['page_id']))
{
    header("Location: index.php");
    exit(0);
} 
else 
{
    $page_id = intval($_POST['page_id']);
}

$admin = LEPTON_admin::getInstance('Pages', 'pages_settings');

$functions = [
	"modify_page_trail",
    "level_count",
    "save_filename",
	"get_page_details"
];
LEPTON_handle::register($functions);

// get current data from DB
$aCurrentPage = get_page_details($page_id);

// check permission
$in_group = false;
$aCurrentAdmins = explode(',', $aCurrentPage['admin_groups']);
$aSessionAdmins = $admin->getValue('groups_id', 'string', 'session',',');

foreach ($aSessionAdmins as $sCurrentGroupId)
{

    if (in_array($sCurrentGroupId, $aCurrentAdmins))
    {
        $in_group = true;
    }
}

if ($in_group == false)
{
    $admin->print_error($MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']);
	exit();
}

// rework and check some values
$_POST["page_title"] = $admin->getValue("page_title", "string_clean", default: "");
$_POST["menu_title"] = $admin->getValue("menu_title", "string_clean", default: "");


//  Get values
$aFields = [
    "page_link"      => ["type" => "str", "default" => ""],
    "page_title"     => ["type" => "string_chars", "default" => ""],
    "menu_title"     => ["type" => "string_chars", "default" => ""],
    "description"    => ["type" => "string_chars", "default" => ""],
    "keywords"       => ["type" => "string_chars", "default" => ""],
    "page_code"      => ["type" => "string_chars", "default" => ""],
    "parent"         => ["type" => "int", "default" => 0],
    "visibility"     => ["type" => "str", "default" => "hidden"], // ! keep in mind
    "page_template"  => ["type" => "str", "default" => ""],       // empty string === default template
    "target"         => ["type" => "str", "default" => "_self"],
    "admin_groups"   => ["type" => "array", "default" => []],     // array!
    "viewing_groups" => ["type" => "array", "default" => []],     // array!,
    "searching"      => ["type" => "int", "default" => 0],
    "language"       => ["type" => "str", "default" => DEFAULT_LANGUAGE],
    "menu"           => ["type" => "int", "default" => 1]
];

$aAllPosts = LEPTON_request::getInstance()->testPostValues($aFields);

// create vars from all post-values
extract( $aAllPosts, EXTR_OVERWRITE );

// Post-Validate some values
if ($page_title == '' || substr($page_title,0,1)== '.')
{
    $admin->print_error($MESSAGE['PAGES_BLANK_PAGE_TITLE']);
}

// Remove entities inside the page title!
$page_title = str_replace(["&amp;amp;","&amp;"], "&", $page_title);

if ($menu_title == '' || substr($menu_title,0,1)=='.')
{
    $admin->print_error($MESSAGE['PAGES_BLANK_MENU_TITLE']);
}

// Remove entities inside the menu title!
$menu_title = str_replace(["&amp;amp;","&amp;"], "&", $menu_title);

// [1] Sprecial entities
LEPTON_handle::restoreSpecialChars($menu_title);
LEPTON_handle::restoreSpecialChars($page_title);

// Remove entities inside the menu description!
$description = str_replace(["&amp;amp;","&amp;"], "&", $description);
LEPTON_handle::restoreSpecialChars($description);

// Remove entities inside the menu keywords!
$keywords = str_replace(["&amp;amp;","&amp;"], "&", $keywords);
LEPTON_handle::restoreSpecialChars($keywords);

if ($page_template === '-1')
{
    $page_template = "";
}

$old_parent     = $aCurrentPage['parent'];
$old_link       = $aCurrentPage['link'];
$old_position   = $aCurrentPage['position'];
$old_admin_groups = explode(',', $aCurrentPage['admin_groups']);

// Create new viewing groups -> string
$viewing_groups[] = 1;
sort($viewing_groups);
$viewing_groups = implode(",", $viewing_groups);

// Create new admin groups -> string
$admin_groups[] = 1;
sort($admin_groups);
$admin_groups = implode(',', $admin_groups);


// Update page settings in the pages table
$fields = [
	'page_title'     => $page_title,
	'menu_title'     => $menu_title,
	'menu'           => $menu,
	'template'       => $page_template,
	'target'         => $target,
	'description'    => $description,
	'keywords'       => $keywords,
	'visibility'     => $visibility,
	'searching'      => $searching,
	'admin_groups'   => $admin_groups,
	'viewing_groups' => $viewing_groups
];

// The following values are only submitted when PAGE_LANGUAGES are enabled! 
if (false !== PAGE_LANGUAGES)
{
	$fields['language']  = $language;
	$fields['page_code'] = $page_code;
}

$database->build_and_execute(
	'update',
	TABLE_PREFIX.'pages',
	$fields,
	"`page_id` = ".$page_id
);	

// initialize correction var for the subpages!
$bResolveSubpagesLinks = false;

$aAllPosts['parent'] = intval($aAllPosts['parent']);

if (intval($aCurrentPage['parent']) === $aAllPosts['parent'])
{
    // url (link) changed
    if ($aCurrentPage['link'] != '/'.$page_link)
    {
        $aLinkParts = explode('/', $aCurrentPage['link']);
        $sPageLink = array_pop($aLinkParts);
        $aLinkParts[] = save_filename($page_link);
        $sNewPageLink = implode('/', $aLinkParts);

        // Check if a page with same page filename exists
        $iPageLinkDouble = $database->get_one("SELECT `page_id` FROM ".TABLE_PREFIX."pages WHERE `link` = '".$sNewPageLink."' AND `page_id` != ".$page_id);

        if (!is_null($iPageLinkDouble))
        {
            $admin->print_error($MESSAGE['PAGES_PAGE_EXISTS'].'['.__LINE__.']');
        }

        // save values
        $database->simple_query("UPDATE `".TABLE_PREFIX."pages` SET `link` = '".$sNewPageLink."' WHERE `page_id`=".$page_id);

        // rename access file
        if (file_exists(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].PAGE_EXTENSION))
        {
            rename(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].PAGE_EXTENSION, LEPTON_PATH.PAGES_DIRECTORY.$sNewPageLink.PAGE_EXTENSION);
        }
		
        // rename dir if there is one
        if (file_exists(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].'/'))
        {
            rename(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].'/', LEPTON_PATH.PAGES_DIRECTORY.$sNewPageLink.'/');
			
			// set correction var for the subpages!
			$bResolveSubpagesLinks = true;
        }		
    }	
}
else
{
    // parent has changed, work out level and root parent
    if (intval($aAllPosts['parent']) != 0)
    {	
        $level = LEPTON_core::level_count($aAllPosts['parent']) + 1;
		$root_parent = $database->get_one("SELECT root_parent FROM ".TABLE_PREFIX."pages WHERE page_id = ".$aAllPosts['parent']);

        $aParentInfo = get_page_details($aAllPosts['parent']);
        $sParentLink = $aParentInfo['link'];

        if ($sParentLink == '/')
        {
            $sParentLink = '';
        }

        $link = $sParentLink.'/'.save_filename($aAllPosts['page_link']);
        $filename = LEPTON_PATH.PAGES_DIRECTORY.$link.PAGE_EXTENSION;

        // Check if a page with same page filename exists
        $iPageLinkDouble = $database->get_one("SELECT `page_id` FROM ".TABLE_PREFIX."pages WHERE `link` = '".$link."' AND `page_id` != ".$page_id);

        if (!is_null($iPageLinkDouble))
        {
            $admin->print_error($MESSAGE['PAGES_PAGE_EXISTS'].'['.__LINE__.']');
        }

        // set correction var for the subpages!
        $bResolveSubpagesLinks = true;
    }
	else
    {
        // parent is 0 - the page is on the top level
        $level = 0;
        $root_parent = $page_id;

        $link = '/'.save_filename($aAllPosts['page_link']);

        // rename menu titles: index to prevent clashes with core file /pages/index.php
        if ($link == '/index')
        {
            $link .= '_'.$page_id;
            $filename = LEPTON_PATH.PAGES_DIRECTORY.$link.PAGE_EXTENSION;
        } else
        {
            $filename = LEPTON_PATH.PAGES_DIRECTORY.$link.PAGE_EXTENSION;
        }

        // Check if a page with same page filename exists
        $iPageLinkDouble = $database->get_one("SELECT `page_id` FROM ".TABLE_PREFIX."pages WHERE `link` = '".$link."' AND `page_id` != ".$page_id);

        if (!is_null($iPageLinkDouble))
        {
            $admin->print_error($MESSAGE['PAGES_PAGE_EXISTS'].'[216]');
        }

        // set correction var for the subpages!
        $bResolveSubpagesLinks = true;
    }

    // include ordering class
    $order = LEPTON_order::getInstance(TABLE_PREFIX.'pages', 'position', 'page_id', 'parent');
    // Get new order
    $position = $order->get_new($aAllPosts['parent']);
    // Clean new order
    $order->clean($aAllPosts['parent']);

	$sParentPageTrail = $database->get_one("SELECT `page_trail` FROM ".TABLE_PREFIX."pages WHERE  `page_id` = ".$aAllPosts['parent']);
	
	if($level == 0) 
	{
		$sCurrentPageTrail = $page_id;
	}
	else
	{
		$sCurrentPageTrail = $sParentPageTrail.','.$page_id;
	}	
	
	// save new values, update page settings in the pages table
	$fields = [
		'parent'         => $aAllPosts['parent'],
		'level'          => $level,
		'page_trail'     => $sCurrentPageTrail,		
		'root_parent'    => $root_parent,
		'position'    	=> $position,
		'link'           => $link,
	];

	// The following values are only submitted when PAGE_LANGUAGES are enabled! 
	if (false !== PAGE_LANGUAGES)
	{
		$fields['language']  = $language;
		$fields['page_code'] = $page_code;
	}

	$database->build_and_execute(
		'update',
		TABLE_PREFIX.'pages',
		$fields,
		"`page_id` = ".$page_id
	);	

	// delete old and write new access file
	if(file_exists(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].PAGE_EXTENSION ))
	{
		unlink(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].PAGE_EXTENSION);
		LEPTON_core::create_access_file($filename,$page_id,$level);
	}
	
	// delete directory for this page	
	if (file_exists(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].'/') && is_dir(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].'/'))
	{
		rename(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].'/', LEPTON_PATH.PAGES_DIRECTORY.$link.'/');
	}
	
	if (is_dir(LEPTON_PATH.PAGES_DIRECTORY.$aCurrentPage['link'].'/'))
	{
		LEPTON_handle::delete_obsolete_directories(PAGES_DIRECTORY.$aCurrentPage['link'].'/');
	}
	
	// check if "old" parent direcory is empty after renaming page file
	$sParentLink = $database->get_one("SELECT `link` FROM ".TABLE_PREFIX."pages WHERE `page_id` = ".$aCurrentPage['parent']);
	
	if(is_dir(LEPTON_PATH.PAGES_DIRECTORY.$sParentLink.'/'))
	{
		$aFilesScan = array_slice(scanDir(LEPTON_PATH.PAGES_DIRECTORY.$sParentLink.'/'), 2);
		if(count($aFilesScan) == 1 && $aFilesScan[0] == 'index.php')
		{
			LEPTON_handle::delete_obsolete_directories(PAGES_DIRECTORY.$sParentLink.'/');
		}
	}

	// Modify sub-pages page trail
	modify_page_trail($aCurrentPage['root_parent'],$root_parent);

}

// Correction of the subpages (links/accessfiles) !
if (true === $bResolveSubpagesLinks)
{
	$link = $database->get_one("SELECT `link` FROM `".TABLE_PREFIX."pages` WHERE `page_id` = ".$page_id);

    // Update any pages with old link, replace with new one
    $iLinkLength = strlen($aCurrentPage['link']);

    $aSubPages = [];
    $database->execute_query(
            "SELECT page_id,link,level FROM ".TABLE_PREFIX."pages WHERE link LIKE '%".$aCurrentPage['link']."/%' ORDER BY LEVEL ASC",
            true,
            $aSubPages,
            true
    );

    if (!empty($aSubPages))
    {
        foreach ($aSubPages as $aSubPage)
        {
            // Double-check to see if it contains 'old' link
            if (substr($aSubPage['link'], 0, $iLinkLength) == $aCurrentPage['link'])
            {
                // Get new link
                $iSubLinkLength = strlen($aSubPage['link']);
                $new_sub_link = $link.'/'.substr($aSubPage['link'], $iLinkLength + 1, $iSubLinkLength);

                // Work out level
                $new_sub_level = LEPTON_core::level_count($aSubPage['page_id']);

                // Update level and link
                $database->simple_query("UPDATE ".TABLE_PREFIX."pages SET link = '".$new_sub_link."', level = '".$new_sub_level."' WHERE page_id = ".$aSubPage['page_id']);

                // Re-write the access file for this page
                $old_subpage_file = LEPTON_PATH.PAGES_DIRECTORY.$new_sub_link.PAGE_EXTENSION;

                if (file_exists($old_subpage_file))
                {
                    unlink($old_subpage_file);
                }
                LEPTON_core::create_access_file(
                    LEPTON_PATH.PAGES_DIRECTORY.$new_sub_link.PAGE_EXTENSION,
                    $aSubPage['page_id'],
                    $new_sub_level
                );
            }
        }
		
        // old dir
        $sDirLink = $aCurrentPage['link'];
        if (is_dir(LEPTON_PATH.PAGES_DIRECTORY.$sDirLink.'/'))
        {
            LEPTON_handle::delete_obsolete_directories([PAGES_DIRECTORY.$sDirLink.'/']);
        }
    }
}

$leptoken = get_leptoken();
$target_url = ADMIN_URL.'/pages/settings.php?page_id='.$page_id."&leptoken=".$leptoken;
$admin->print_success($MESSAGE['PAGES_SAVED_SETTINGS'], $target_url );

