<?php

/**
 *  @template       Semantic
 *  @version        see info.php of this template
 *  @author         cms-lab
 *  @copyright      2010-2025 CMS-LAB
 *  @license        https://creativecommons.org/licenses/by/3.0/
 *  @license terms  see info.php of this template
 *  @platform       see info.php of this template
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {
    include LEPTON_PATH.SEC_FILE;
} else {
    $oneback = "../";
    $root = $oneback;
    $level = 1;
    while (($level < 10) && (!file_exists($root.SEC_FILE))) {
        $root .= $oneback;
        $level += 1;
    }
    if (file_exists($root.SEC_FILE)) {
        include $root.SEC_FILE;
    } else {
        trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
    }
}
// end include secure file

global $info_text;
$database = LEPTON_database::getInstance();
// init empty string as we've got no message to display here in this line!
$info_text = "";

// create hash 
$confirm_hash = time();

// create confirmation link
$enter_pw_link = LEPTON_URL.'/account/new_password.php?hash='.$confirm_hash;

// Check if the user has already submitted the form, otherwise show it
$email = LEPTON_core::getValue('email','email','post');
if(!is_null($email))
{
	//	check if mail is in database
	$subscriber = [];
	$database->execute_query(
		"SELECT * FROM ".TABLE_PREFIX."users WHERE email = '".$email."' ",
		true,
		$subscriber,
		false
	);

	if(empty($subscriber)) 
	{
		// info that email doesn't exist	
		$info_text = $MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND'];
	
	} 
	else 
	{
		// Check if the password has been reset in the last 2 hours
		$last_reset = intval($subscriber['login_ip']); 
		$time_diff = time()-$last_reset; // Time since last reset in seconds
		if($time_diff < MAX_REGISTRATION_TIME)
		{
			// Tell the user that their password cannot be reset more than once per hour
			$info_text = $MESSAGE['FORGOT_PASS_ALREADY_RESET'];		
		} 
		else 
		{
			//send confirmation link to email
			$mail = LEPTON_mailer::getInstance();
			$mail->addAddress($email);
			//Set the subject line
			$mail->Subject = $MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO'];
			$mail->Body = sprintf($MESSAGE['FORGOT_PASS_PASSWORD_CONFIRM'],$enter_pw_link,$enter_pw_link);	

			//send the message, check for errors
			if (!$mail->send()) 
			{
				$info_text = "Mailer Error: " . $mail->ErrorInfo;
			} 
			else 
			{
				//save into database
				$fields = [ 'login_ip' =>	$confirm_hash ];
				$database->build_and_execute( 'UPDATE', TABLE_PREFIX."users", $fields,"email = '".$email."' ");
			
				$info_text = $MESSAGE['FORGOT_PASS_PASSWORD_RESET'];			
			}
		}
	}
}

if($info_text == '')
{
	$info_text = $MESSAGE['FORGOT_PASS_NO_DATA'];
	$info_color = '000000';
} 
else 
{
	$info_color = 'FF0000';
}

$oAC = account::getInstance();

$hash = sha1( microtime().$_SERVER['HTTP_USER_AGENT'] );
$_SESSION['wb_apf_hash'] = $hash;

$redirect_url = (isset($_SESSION['HTTP_REFERER']) ? $_SESSION['HTTP_REFERER'] : "");

unset($_SESSION['result_message']);

$data = array( 
	'MESSAGE_COLOR'		=>	$info_color,
	'MESSAGE'		    =>	$info_text,
	'FORGOT_URL'		=>	FORGOT_URL,  
	'URL'			    =>	$redirect_url,
	'AUTH_MAX_LOGIN_LENGTH'	=>	AUTH_MAX_LOGIN_LENGTH,		
	'HASH'				=>	$hash
);

echo $oAC->oTWIG->render("forgot_form.lte", $data);
