<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          Website Baker Project, LEPTON Project
 * @copyright       2004-2010 Website Baker Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl-3.0.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file


// Make sure the login is enabled
if(!FRONTEND_LOGIN) 
{
    header('Location: '.LEPTON_URL.'/index.php');
    exit(0);		
}

$TEXT = LEPTON_core::getGlobal("TEXT");

// Required page details
$page_id = 0;
$page_description = '';
$page_keywords = '';
const PAGE_ID = 0;
define('ROOT_PARENT', 0);
define('PARENT', 0);
define('LEVEL', 0);
define('PAGE_TITLE', $TEXT['PLEASE_LOGIN']);
define('MENU_TITLE', $TEXT['PLEASE_LOGIN']);
define('VISIBILITY', 'public');

// Set the page content include file
define('PAGE_CONTENT', LEPTON_PATH.'/account/login_form.php');

$salt = sha1(microtime());

// Create new login app
$redirect = strip_tags((isset($_POST['redirect'])) ? $_POST['redirect'] : ((isset($_GET['redirect'])) ? $_GET['redirect'] : ''));

$thisApp = LEPTON_login::getInstance( [
    "USERNAME_FIELDNAME" => $TEXT['USERNAME']."_".substr($salt, 0, 16),
    "PASSWORD_FIELDNAME" => $TEXT['PASSWORD']."_".substr($salt, 15, 16),
	"LOGIN_URL" => LEPTON_URL."/account/login.php?redirect=" .$redirect,
	"DEFAULT_URL" => LEPTON_URL.PAGES_DIRECTORY."/index.php",
	"WARNING_URL" => THEME_URL."/templates/warning.html",	
	"TEMPLATE_DIR" => THEME_PATH."/templates",
	"TEMPLATE_FILE" => "",	
	"frontend" => true,
	"FORGOTTEN_URL" => LEPTON_URL."/account/forgot.php",	
	"REDIRECT_URL" => $redirect
]);


// Include the index (wrapper) file
require(LEPTON_PATH.'/index.php');

