<!DOCTYPE html>
<html>
<head>
<title>LEPTON CMS check server</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<script type='text/javascript' src='https://doc.lepton-cms.org/modules/lib_fomantic/dist/semantic.min.js' ></script>
<link rel="stylesheet" type="text/css" href="https://doc.lepton-cms.org/modules/lib_fomantic/dist/semantic.min.css" media="screen,projection" />	
<link href="https://doc.lepton-cms.org/_packinstall/style_300.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="update_form">

	<div class="ui basic segment">
		<div id="logo">
			<img src="https://doc.lepton-cms.org/_packinstall/img/logo.png" alt="Logo" />
		</div>
		<div id="form_title">
			<h2>SERVER-CHECK</h2>
			<p><a href="https://cms-lab.com" target="_blank">by CMS-LAB</a></p>
		</div>	
	</div>

	<div class="ui basic segment">
		<?php

		/**
		 *	@filename: check.php
		 *	@description: a very simple checker to see if LEPTON requirements are met
		 *	@author:https://cms-lab.com
		 *	@copyright: 2010 - 2024 cms-lab, all rights reserved. 
		 *	@home  https://cms-lab.com
		 *	@version: 0.3.7
		 *
		 */
		 
		extension_check(array( 
			//'gd'
		));

		function extension_check($extensions) {
			$fail = '';
			$pass = '';
			$gd_info = gd_info();
			
			if(version_compare(phpversion(), '8.1', '<')) {
				$fail .= '<li>You need<strong> PHP 8.1 </strong> (8.2.x recommended) but it seems you have <strong>'.PHP_VERSION.'</strong></li>';
			} else {
				$pass .='<li>You have<strong> PHP '.PHP_VERSION.'</strong></li>';
			}

		
			if(empty($gd_info)) 
			{
				$fail .= '<li>You need<strong> GD Library to be installed (mandantory)</strong></li>';
			} 
			else 
			{
				$pass .='<li>You got<strong> GD Library '.$gd_info['GD Version'].' </strong>installed.</li>';
			}

			if(!ini_get('safe_mode')) {
			  $pass .='<li>Safe Mode is <strong>off</strong></li>';
			 } else {
			  $fail .= '<li>Safe Mode is <strong>on</strong></li>';
			 }

			if(!in_array("mysql", PDO::getAvailableDrivers())) {
			   $fail .= '<li>You need<strong> PDO mysql installed</strong></li>';
			  } else {
			   $pass .='<li>You have<strong> PDO MySQL</li>';
			}
			  
			foreach($extensions as $extension) 
			{
				if(!extension_loaded($extension)) 
				{
					$fail .= '<li> You are missing the <strong>'.$extension.'</strong> extension</li>';
				} 
				else 
				{
					$pass .= '<li>You have the <strong>'.$extension.'</strong> extension</li>';
				}
			}
			
			if($fail) {
				echo '<div class="ui negative message"><h3>Your server does not meet the following requirements in order to install current LEPTON CMS</h3>';
				echo '<br>The following requirements <strong>failed</strong>, please contact your hosting provider in order to receive assistance with meeting the system requirements for LEPTON CMS:';
				echo '<ul>'.$fail.'</ul>';
				echo '<strong>The following requirements were successfully met:</strong>';
				echo '<ul>'.$pass.'</ul></div>';
			} else {
				echo '<div class="ui positive message"><h3>Congratulations! Your server meets the requirements of current LEPTON CMS</h3>';
				echo '<ul>'.$pass.'</ul>';
				echo '<p><a class="dl" href="https://lepton-cms.org" target="_blank">Please download the full package on LEPTON Project Site</a></p></div>';
			}
		}
		?>
		
		<div class = "ui blue message">
			<?php
			 echo '<h3>For your information only: your server configuration details</h3>';
			 echo '<p style="color:red;">Please delete this file from your webspace when finished</p>';
			 echo 'Your SERVER API is: '.php_sapi_name().'<br />';
			 if (isset($_GET['details']) && ($_GET['details'] == 1)) 
			 {
				phpinfo();
			 } 
			 else 
			 {
				echo "<a class='dl' href=\"".$_SERVER['PHP_SELF']."?details=1\">PHP-Details (phpinfo)</a>";
			 }
			 ?> 
		</div>		
	</div>	

	<div class="spacer"></div>
</div>

</body>
</html>